import PropTypes from 'prop-types';
import React from 'react';

import PureRenderMixin from 'react-addons-pure-render-mixin';
import InvitesActions from 'actions/Invite';
import { i18n } from 'lib/i18n';

import InviteStore from 'stores/Invites';
import StoreMixin from 'lib/StoreMixin';
import AddInviteLink from './AddInviteLink';

const AddInviteLinksContainer = React.createClass({

    mixins: [StoreMixin, PureRenderMixin],

    getInitialState() {
        return {
            loading: false,
            error: null,
        };
    },

    getStoreState() {
        const { departmentId } = this.props;
        const code = InviteStore.getCodeByDepartmentId(departmentId);

        return {
            code,
            active: Boolean(code),
        };
    },

    componentDidMount() {
        const { departmentId } = this.props;

        this.setState({
            loading: true,
            initing: true,
        });

        InvitesActions.readInviteLink({ departmentId: Number(departmentId) })
            .finally(() => {
                this.setState({
                    loading: false,
                });
            })
            .then(() => {
                this.setState({
                    initing: false,
                });
            });

        this.subscribe([InviteStore]);
    },

    _onChange({ target: { checked } }) {
        this.setState({
            loading: true,
            error: null,
            active: Boolean(checked),
        });

        if (checked) {
            this._createInviteLink();

            return;
        }

        this._removeInviteLink();
    },

    _createInviteLink() {
        const { departmentId } = this.props;

        InvitesActions.createInviteLink({ departmentId: Number(departmentId) })
            .finally(() => {
                this.setState({ loading: false });
            })
            .then(({ errors }) => {
                if (errors) {
                    this._setError();
                    this.setState({ active: false });
                }
            })
            .catch(() => {
                this._setError();
            });
    },

    _removeInviteLink() {
        const { departmentId } = this.props;

        InvitesActions.removeInviteLink({ departmentId: Number(departmentId) })
            .finally(() => {
                this.setState({ loading: false });
            })
            .then(({ errors }) => {
                if (errors) {
                    this._setError();
                    this.setState({ active: true });
                }
            })
            .catch(() => {
                this._setError();
            });
    },

    _setError() {
        this.setState({ error: i18n('department.error.invite_link') });
    },

    render() {
        const { code, active, error, loading, initing } = this.state;

        return (
            <AddInviteLink
                onChange={this._onChange}
                code={code}
                active={active}
                error={error}
                initing={initing}
                loading={loading}
            />
        );
    },

});

AddInviteLink.propTypes = {
    departmentId: PropTypes.string,
};

export default AddInviteLinksContainer;
