import PropTypes from 'prop-types';
import React, { Component } from 'react';

import './invite-link.css';

import Icon from 'ui/Icon';
import clipboard from 'lib/clipboard';

class InviteLink extends Component {
    constructor() {
        super(...arguments);
        this._setInputRef = this._setInputRef.bind(this);
        this._onCopyLinkClick = this._onCopyLinkClick.bind(this);
    }

    componentDidMount() {
        this._selectLink();
    }

    render() {
        const { inviteLink } = this.props;

        return (
            <div className="invite-link">
                <input
                    className="invite-link__input"
                    key="input"
                    ref={this._setInputRef}
                    readOnly
                    value={inviteLink}
                />
                <span
                    className="invite-link__copy"
                    key="copy"
                    onClick={this._onCopyLinkClick}
                >

                    <Icon type="copy" />
                </span>
            </div>
        );
    }

    _setInputRef(input) {
        this._input = input;
    }

    _getInputRef() {
        return this._input;
    }

    _selectLink() {
        const current = this._getInputRef();
        const { inviteLink } = this.props;

        if (clipboard.copy(inviteLink)) {
            try {
                // Это имитация, чтобы пользователь видел, что что-то произошло
                current.focus();
                current.select();
            } catch (err) {
                // noop
            }
        }
    }

    _onCopyLinkClick() {
        this._selectLink();
    }
}

InviteLink.propTypes = {
    inviteLink: PropTypes.string,
};

export default InviteLink;
