import PropTypes from 'prop-types';
import React from 'react';
import { Permissions } from 'constants/Common';
import { i18n } from 'lib/i18n';
import AuthStore from 'stores/Auth';
import PermissionStore from 'stores/Permissions';

import Form from 'ui/Form';
import Input from 'ui/Input';

function isDisabled() {
    return !PermissionStore.contains(Permissions.EDIT_USER_INFO);
}

const Login = React.createClass({
    render() {
        const { errors } = this.props;

        return (
            <Form.Item
                className="user-nickname"
                label={i18n('user.nickname')}
                errors={errors.nickname}
                required
            >
                <Input
                    name={Form.getSafeFieldName('nickname')}
                    hasClear
                    size="m"
                    autoComplete={false}
                    disabled={isDisabled()}
                    width="available"
                    suffix={`@${AuthStore.getOrganizationDomain()}`}
                />
            </Form.Item>
        );
    },
});

Login.propTypes = {
    errors: PropTypes.object,
};

Login.defaultProps = {
    errors: {},
};

export default Login;
