import React from 'react';
import { block } from 'bem-cn';
import { i18n } from 'lib/i18n';

import InviteForm from 'components/InviteForm';

import notify from 'services/notify';
import AddInviteLinkContainer from './Components/AddInviteLinkContainer';

import './invite.css';

const b = block('invite-form-container');

const Invite = React.createClass({

    _onInviteSubmit() {
        const { onSubmit } = this.props;

        notify(i18n('invites.notification.success'), 'success');
        onSubmit();
    },

    render() {
        const { departmentId } = this.props;

        return (
            <div className={b()}>
                <AddInviteLinkContainer departmentId={departmentId} />
                <div className={b('emails')}>
                    <InviteForm
                        label={i18n('invites.labels.input')}
                        buttonText={i18n('invites.buttons.invite')}
                        departmentId={departmentId}
                        onSubmit={this._onInviteSubmit}
                    />
                </div>
            </div>
        );
    },
});

export default Invite;
