function filterInput(data) {
    if (data.nickname) {
        data.nickname = data.nickname.toLowerCase();
    }

    if (data.department_id !== undefined) {
        // если пользователю не задан отдел, пользователь записывается
        // в корневой отдел { id: 1 }
        data.department_id = data.department_id === '' ? 1 : Number(data.department_id);
    }

    if (data.password_change_required !== undefined) {
        data.password_change_required = Boolean(data.password_change_required);
    }

    if (data.birthday === '') {
        data.birthday = null;
    }

    if (data.gender === '') {
        data.gender = null;
    }

    if (data.contacts) {
        data.contacts = data.contacts.filter(
            item => item.value ? item.value.trim() : item.value
        );
    }

    if (data.aliases) {
        data.aliases = data.aliases.filter(
            alias => alias ? alias.trim() : alias
        );
    }

    return data;
}

export default filterInput;
