import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import StoreMixin from 'lib/StoreMixin';
import UserStore from 'stores/Users';
import GroupStore from 'stores/Groups';
import { i18n } from 'lib/i18n';
import Url from 'lib/Url';
import Link from 'ui/Link';

import './index.css';

const Groups = React.createClass({

    mixins: [StoreMixin, PureRenderMixin],

    getStoreState() {
        const user = UserStore.get(this.props.id);

        return {
            groups: user ? GroupStore.getOrderedList(user.getGroups()) : null,
        };
    },

    componentDidMount() {
        this.subscribe([
            UserStore,
            GroupStore,
        ]);
    },

    render() {
        const { groups } = this.state;

        if (!groups || !groups.length) {
            return null;
        }

        const items = groups.map(group => {
            const name = group.getName();
            const url = Url.getGroupPath('all', group.id);

            return (
                <div className="list-item__value-item" key={`user-group-${group.id}`}>
                    <Link
                        className="link"
                        to={url}
                        title={name}
                        metrika={['Карточка пользователя', 'Клик в группу']}
                    >
                        {name}
                    </Link>
                </div>
            );
        });

        return (
            <div className="user-groups separated-subsection">
                <div className="list-item">
                    <div className="list-item__key" title={i18n('user.groups')}>
                        {i18n('user.groups')}:
                    </div>
                    <div className="list-item__value">
                        {items}
                    </div>
                </div>
            </div>
        );
    },

});

Groups.propTypes = {
    id: PropTypes.string,
};

export default Groups;
