import PropTypes from 'prop-types';

import Avatar from 'ui-components/lib/Avatar';
import Identity from './Identity';
import Contacts from './Contacts';

import './index.css';
import './hover-card.css';

const HoverCard = props => {
    const { user } = props;

    if (!user) {
        return null;
    }

    return (
        <div className="user-hover-card hover-card">
            <div className="side-container">
                <Avatar url={user.getAvatar()} size="l" />
            </div>
            <div className="main-container">
                <Identity user={user} compact />
                <Contacts id={user.getId()} compact />
            </div>
        </div>
    );
};

HoverCard.propTypes = {
    user: PropTypes.object.isRequired,
};

export default HoverCard;
