import PropTypes from 'prop-types';
import React from 'react';
import classSet from 'classnames';
import { i18n, getTimezoneDescription } from 'lib/i18n';
import Avatar from 'components/UserAvatar';

import './index.css';

const Identity = React.createClass({

    _renderHeader(user) {
        const { compact, editableAvatar } = this.props;
        let avatar;

        if (!compact) {
            avatar = (
                <div className="user-identity__avatar">
                    <Avatar user={user} editable={editableAvatar} />
                </div>
            );
        }

        return (
            <div className="user-identity__header">
                {avatar}
                <div className="user-identity__name" title={user.getName()}>
                    {user.getName()}
                </div>
                <div className="user-identity__position" title={user.getPosition()}>
                    {user.getPosition()}
                </div>
                <div className="user-identity__block-status">
                    <span className="user-identity__block-badge">
                        {i18n('user.blocked')}
                    </span>
                </div>
            </div>
        );
    },

    _renderBody(user) {
        const items = [];

        if (!this.props.compact && user.get('birthday')) {
            items.push(
                <div className="list-item" key="birthDate">
                    <div className="list-item__key" title={i18n('user.birth_date')}>
                        {i18n('user.birth_date')}:
                    </div>
                    <div className="list-item__value">
                        {user.getDisplayableBirthDate(this.props.locale)}
                    </div>
                </div>
            );
        }

        const currentLang = user.get('language');

        if (!this.props.compact && currentLang !== undefined) {
            items.push(
                <div className="list-item" key="language">
                    <div className="list-item__key" title={i18n('user.language')}>
                        {i18n('user.language')}:
                    </div>
                    <div className="list-item__value" title={i18n(`common_vocab.lang.${currentLang}`)}>
                        {i18n(`common_vocab.lang.${currentLang}`)}
                    </div>
                </div>
            );
        }

        const timezone = user.get('timezone');

        if (!this.props.compact && timezone !== undefined) {
            items.push(
                <div className="list-item" key="timezone">
                    <div className="list-item__key" title={i18n('user.timezone')}>
                        {i18n('user.timezone')}:
                    </div>
                    <div className="list-item__value" title={getTimezoneDescription(timezone)}>
                        {getTimezoneDescription(timezone)}
                    </div>
                </div>
            );
        }

        if (!items.length) {
            return null;
        }

        return (
            <div className="list separated-subsection">
                {items}
            </div>
        );
    },

    render() {
        const { user } = this.props;

        if (!user) {
            return null;
        }

        const className = classSet({
            'user-identity': true,
            'user-identity_blocked': !user.get('is_enabled'),
        });

        return (
            <div className={className}>
                {this._renderHeader(user)}
                {this._renderBody(user)}
            </div>
        );
    },

});

Identity.propTypes = {
    user: PropTypes.object.isRequired,
    locale: PropTypes.string,
    compact: PropTypes.bool,
    editableAvatar: PropTypes.bool,
};

export default Identity;
