import _ from 'lodash';
import PropTypes from 'prop-types';
import React from 'react';
import { i18n } from 'lib/i18n';
import UserStore from 'stores/Users';
import AuthStore from 'stores/Auth';
import ConfigStore from 'stores/Config';
import Link from 'ui/Link';

import './index.css';

const Services = React.createClass({

    render() {
        const user = UserStore.get(this.props.id);
        const component = {};

        if (!user) {
            return null;
        }

        if (AuthStore.isInternal() && AuthStore.isServiceEnabled('yamb')) {
            component.yambLink = (
                <Link
                    to={user.getPrivateYambChatUrl()}
                    target="_blank"
                    metrika={['Карточка пользователя', 'Написать сообщение']}
                    className="button button_size_m button_theme_islands"
                >
                    <span className="button__text">
                        {i18n('common.action.send_message')}
                    </span>
                </Link>
            );
        }

        if (AuthStore.isInternalAdmin() && ConfigStore.get('ui.staffModeEnabled')) {
            component.staffLink = (
                <Link
                    to={user.getExternalStaffUrl()}
                    target="_blank"
                    metrika={['Карточка пользователя', 'Больше информации']}
                    className="button button_size_m button_theme_islands"
                >
                    <span className="button__text">
                        {i18n('user.more_info')}
                    </span>
                </Link>
            );
        }

        if (_.isEmpty(component)) {
            return null;
        }

        return (
            <div className="user-interaction-controls subsection">
                {component.yambLink}
                {component.staffLink}
            </div>
        );
    },

});

Services.propTypes = {
    id: PropTypes.string,
};

export default Services;
