import PropTypes from 'prop-types';
import React from 'react';
import PureRenderMixin from 'react-addons-pure-render-mixin';
import Scrollable from 'ui/Scrollable';
import UIActions from 'actions/UI';

import FlatButton from 'ui/FlatButton';
import Icon from 'ui/Icon';
import { i18n } from 'lib/i18n';
import UpdateForm from './Forms/Update';

const UpdateSection = React.createClass({

    mixins: [PureRenderMixin],

    _handleEditDone() {
        UIActions.userEdited(this.props.id);
    },

    render() {
        const { id } = this.props;

        return (
            <div className="update-user-section card-section card-section_highlighted section">
                <div className="section-body">
                    <Scrollable>

                        <UpdateForm
                            id={id}
                            onSubmit={this._handleEditDone}
                            onCancel={this._handleEditDone}
                        />

                        <div className="section__close">
                            <FlatButton
                                onClick={this._handleEditDone}
                                ariaLabel={i18n('common.action.cancel')}
                            >

                                <Icon type="cross" />
                            </FlatButton>
                        </div>

                    </Scrollable>
                </div>
            </div>
        );
    },

});

UpdateSection.propTypes = {
    id: PropTypes.string,
};

export default UpdateSection;
