import PropTypes from 'prop-types';
import React from 'react';
import Avatar from 'ui-components/lib/Avatar';
import { i18n } from 'lib/i18n';
import FlatButton from 'ui/FlatButton';
import Icon from 'ui/Icon';

import ModalActions from 'actions/Modal';
import ChangeAvatarForm from '../User/Forms/ChangeAvatar';

const EditableAvatar = React.createClass({
    _handleButtonClick() {
        ModalActions.open({
            component: ChangeAvatarForm,
            title: i18n('avatar.title'),
            props: {
                id: this.props.user.getId(),
                onSubmit: this._handleFormDone,
                onCancel: this._handleFormDone,
            },
        });
    },

    _handleFormDone() {
        ModalActions.close();
    },

    render() {
        const { user, ...avatarProps } = this.props;
        const classes = [
            'user-avatar',
            'user-avatar_editable',
            `user-avatar_${user.getRole()}`,
        ].join(' ');

        return (
            <FlatButton
                className={classes}
                onClick={this._handleButtonClick}
                ariaLabel={i18n('user.action_description.edit_avatar', {
                    name: user.getName(),
                })}
            >

                <Avatar {...avatarProps} url={user.getAvatar()} />

                <Icon type="photo" size="xl" />
            </FlatButton>
        );
    },
});

EditableAvatar.propTypes = {
    user: PropTypes.object.isRequired,
};

EditableAvatar.defaultProps = {
    size: 'xxl',
};

export default EditableAvatar;
