import PropTypes from 'prop-types';
import Avatar from 'ui-components/lib/Avatar';
import EditableAvatar from './EditableAvatar';

import './index.css';

const UserAvatar = ({ user, editable, ...avatarProps }) => {
    if (!user) {
        return null;
    }

    if (!editable) {
        return (
            <Avatar {...avatarProps} url={user.getAvatar()} />
        );
    }

    return <EditableAvatar user={user} {...avatarProps} />;
};

UserAvatar.propTypes = {
    user: PropTypes.object.isRequired,
    editable: PropTypes.bool,
};

UserAvatar.defaultProps = {
    editable: false,
    size: 'xxl',
};

export default UserAvatar;
