import React from 'react';
import { block } from 'bem-cn';
import Header from 'components2/Header';
import Context from 'components2/Context';
import isExternalAdmin from 'lib2/isExternalAdmin';

import './index.css';

const b = block('app-layout');
const isIframe = new URL(window.location.href).searchParams.get('iframe') === '1';

export default () => (
    <div className={b({ widget: isIframe })}>
        {!isIframe && (
            <Header
                cls={b('header')}
                hasSearchBox={!isExternalAdmin()}
            />
        )}
        <Context cls={b('body')} isIframe={isIframe} />
    </div>
);
