import React from 'react';
import { block } from 'bem-cn';
import Header from 'components2/Header';
import Dashboard from 'components2/Dashboard';
import Footer from 'components2/Footer';
import BunkerNotification from 'components2/BunkerNotification';
import DebtNotification from 'components2/DebtNotification';
import StatusNotifications from 'components2/StatusNotifications';
import ReorgNotification from 'components2/ReorgNotification/adminonly';
import NewsMailModal from 'components2/NewsMailModal';
import LeaveOrganizationModal from 'components2/LeaveOrganizationModal';
import isExternalAdmin from 'lib2/isExternalAdmin';

import './index.css';

const bAppLayout = block('app-layout');

export default () => (
    <div className={bAppLayout()}>
        <StatusNotifications />
        <BunkerNotification nodeKey="survey" />
        <Header
            cls={bAppLayout('header')}
            hasSearchBox={!isExternalAdmin()}
        />
        <ReorgNotification />
        <DebtNotification />
        <Dashboard cls={bAppLayout('body')} />
        <Footer
            cls={bAppLayout('footer')}
            showDownloads
        />
        <NewsMailModal />
        <LeaveOrganizationModal />
    </div>
);
