import React from 'react';
import { Router, Switch, Route } from 'react-router-dom';
import block from 'bem-cn';
import Header from 'components2/Header';
import BunkerNotification from 'components2/BunkerNotification';
import StatusNotifications from 'components2/StatusNotifications';
import ReorgNotification from 'components2/ReorgNotification/adminonly';
import NewsMailModal from 'components2/NewsMailModal';
import OrgProfile from 'components2/OrgProfile';
import BalancePage from 'components2/BalancePage';
import CreateContractPage from 'components2/CreateContractPage';
import NotFound from 'components2/NotFound';
import isExternalAdmin from 'lib2/isExternalAdmin';
import hasPermission from 'lib2/hasPermission';
import AppHistory from 'lib2/AppHistory';
import './index.css';

const b = block('app-layout');
const asIframe = new URL(window.location.href).searchParams.get('iframe') === '1';

export default () => (
    <div className={b({ widget: asIframe })}>
        {!asIframe && (
            <React.Fragment>
                <StatusNotifications />
                <BunkerNotification nodeKey="survey" />
                <Header
                    cls={b('header')}
                    hasSearchBox={!isExternalAdmin()}
                />
                <ReorgNotification />
                <NewsMailModal />
            </React.Fragment>
        )}
        <Router history={AppHistory}>
            <Switch>
                <Route exact path="/portal/profile">
                    <OrgProfile cls={b('body')} />
                </Route>
                {hasPermission('can_pay') && (
                    <React.Fragment>
                        <Route exact path="/portal/balance/contract">
                            <CreateContractPage
                                cls={b('body')}
                                asIframe={asIframe}
                            />
                        </Route>
                        <Route exact path="/portal/balance">
                            <BalancePage cls={b('body')} />
                        </Route>
                    </React.Fragment>
                )}
                <Route path="*">
                    <NotFound />
                </Route>
            </Switch>
        </Router>
    </div>
);
