import React from 'react';
import { Router, Switch, Route } from 'react-router-dom';
import { Link } from 'lego-on-react';
import block from 'bem-cn';
import AppLayout from 'components2/AppLayout';
import SimpleServicePage from 'components2/SimpleServicePage';
import SubscriptionServicePage from 'components2/SubscriptionServicePage';
import ServiceActionLink from 'components2/ServiceActionLink';
import ServiceViewLink from 'components2/ServiceViewLink';
import ServiceBadge from 'components2/ServiceBadge';
import ResourcePage from 'components2/ResourcePage';
import ResourceServicePage from 'components2/ResourceServicePage';
import DomainServicePage from 'components2/DomainServicePage';
import DomainPage from 'components2/DomainPage';
import MailServiceRedirect from 'components2/MailServiceRedirect';
import isExternalAdmin from 'lib2/isExternalAdmin';
import isPartnerOrganization from 'lib2/isPartnerOrganization';
import getService from 'lib2/getService';
import AppHistory from 'lib2/AppHistory';
import { i18n } from 'i18n2';

import './index.css';

const b = block('app-services');

export default () => (
    <Router history={AppHistory}>
        <Switch>
            <Route
                path="/portal/services/:serviceSlug(browser|calendar|forms|landings|staff|wiki|yamb)"
                render={({ match: { params: { serviceSlug } } }) => (
                    <AppLayout cls={b()}>
                        <SimpleServicePage
                            cls={b('body')}
                            serviceSlug={serviceSlug}
                            actions={[
                                <ServiceActionLink
                                    serviceSlug={serviceSlug}
                                    key="action"
                                />,
                                <ServiceViewLink
                                    serviceSlug={serviceSlug}
                                    key="view"
                                />,
                            ]}
                        />
                    </AppLayout>
                )}
            />
            <Route path="/portal/services/mail">
                <MailServiceRedirect />
            </Route>
            <Route path="/portal/services/disk">
                <AppLayout cls={b()}>
                    <SimpleServicePage
                        cls={b('body')}
                        serviceSlug="disk"
                        actions={[
                            <Link
                                theme="normal"
                                url={getService('disk').settings_url}
                                text={i18n('service_page.disk.go')}
                                key="view"
                            />,
                        ]}
                    />
                </AppLayout>
            </Route>
            <Route path="/portal/services/tracker">
                <AppLayout cls={b()}>
                    <SubscriptionServicePage
                        cls={b('body')}
                        serviceSlug="tracker"
                        subscriberSearchType={isPartnerOrganization() ? 'user' : 'all'}
                        actions={[
                            <ServiceActionLink
                                serviceSlug="tracker"
                                key="action"
                            />,
                            !isExternalAdmin() &&
                            <ServiceViewLink
                                serviceSlug="tracker"
                                key="view"
                            />,
                        ]}
                        tabs={{
                            subscriptions: true,
                            requests: true,
                            link: true,
                        }}
                        badge={(
                            <ServiceBadge
                                serviceSlug="tracker"
                                canShowTrialStatus
                                canShowReadOnly
                            />
                        )}
                    />
                </AppLayout>
            </Route>
            <Route
                path="/portal/services/:serviceSlug(metrika)/resources/:resourceId"
                render={({ match: { params: { serviceSlug, resourceId } } }) => (
                    <AppLayout cls={b()}>
                        <ResourcePage
                            cls={b('body')}
                            serviceSlug={serviceSlug}
                            resourceId={resourceId}
                            tabs={{
                                relations: true,
                                requests: true,
                            }}
                        />
                    </AppLayout>
                )}
            />
            <Route
                path="/portal/services/:serviceSlug(alice_b2b|direct)/resources/:resourceId"
                render={({ match: { params: { serviceSlug, resourceId } } }) => (
                    <AppLayout cls={b()}>
                        <ResourcePage
                            cls={b('body')}
                            serviceSlug={serviceSlug}
                            resourceId={resourceId}
                            tabs={{
                                relations: true,
                                requests: false,
                            }}
                        />
                    </AppLayout>
                )}
            />
            <Route
                path="/portal/services/:serviceSlug(yandexsprav)/resources/:resourceId"
                render={({ match: { params: { serviceSlug, resourceId } } }) => (
                    <AppLayout cls={b()}>
                        <ResourcePage
                            cls={b('body')}
                            serviceSlug={serviceSlug}
                            resourceId={resourceId}
                            tabs={{
                                relations: false,
                                requests: false,
                            }}
                        />
                    </AppLayout>
                )}
            />
            <Route
                path="/portal/services/:serviceSlug(alice_b2b|direct|metrika|yandexsprav)"
                render={({ match: { params: { serviceSlug } } }) => (
                    <AppLayout cls={b()}>
                        <ResourceServicePage
                            cls={b('body')}
                            serviceSlug={serviceSlug}
                        />
                    </AppLayout>
                )}
            />
            <Route
                path="/portal/services/webmaster/resources/:resourceId"
                render={({ match: { params: { resourceId } } }) => (
                    <AppLayout cls={b()}>
                        <DomainPage
                            cls={b('body')}
                            name={resourceId}
                        />
                    </AppLayout>
                )}
            />
            <Route path="/portal/services/webmaster">
                <AppLayout cls={b()}>
                    <DomainServicePage cls={b('body')} />
                </AppLayout>
            </Route>
        </Switch>
    </Router>
);
