import React from 'react';
import block from 'bem-cn';
import Header from 'components2/Header';
import Footer from 'components2/Footer';
import BunkerNotification from 'components2/BunkerNotification';
import StatusNotifications from 'components2/StatusNotifications';
import ReorgNotification from 'components2/ReorgNotification/adminonly';
import NewsMailModal from 'components2/NewsMailModal';
import isExternalAdmin from 'lib2/isExternalAdmin';

import './index.css';

const b = block('app-layout');

const AppLayout = ({ children, cls }) => (
    <div className={b({}).mix(cls)}>
        <StatusNotifications />
        <BunkerNotification nodeKey="survey" />
        <Header
            cls={b('header')}
            hasSearchBox={!isExternalAdmin()}
        />
        <ReorgNotification />
        <div className={b('body')}>
            {children}
        </div>
        <Footer
            cls={b('footer')}
            showDownloads
        />
        <NewsMailModal />
    </div>
);

export default AppLayout;
