import React from 'react';
import { block } from 'bem-cn';
import getAvatarUrl from 'lib2/getAvatarUrl';
import getName from 'lib2/getName';
import { i18n, pluralize } from 'i18n2';

import './index.css';

const b = block('avatar-unit');

export default ({ object, type = 'user', cls }) => {
    if (!object) {
        return null;
    }

    let {
        id,
        nickname,
        avatar_id: avatarId,
        avatar_url: avatarUrl,
        description,
        members_count: membersCount,
    } = object;

    if (avatarId) {
        avatarUrl = getAvatarUrl(avatarId);
    }

    if (type === 'user') {
        description = nickname ? `@${nickname}` : '';
    } else if (typeof membersCount === 'number') {
        description = pluralize(membersCount, i18n('common.employees'));
    }

    let name = getName(object);

    return (
        <div
            className={b({ type }).mix(cls)}
            data-id={id}
            data-name={name}
        >
            <div
                className={b('avatar')}
                style={avatarUrl ? { backgroundImage: `url(${avatarUrl})` } : null}
            />
            <div className={b('name')}>
                {name}
            </div>
            {description &&
            <div className={b('description')}>
                {description}
            </div>}
        </div>
    );
};
