import React from 'react';
import { Icon } from 'lego-on-react';
import block from 'bem-cn';
import LeftArrowIcon from 'components/Icon/LeftArrow';
import './index.css';

const b = block('back-button');

const BackButton = ({ cls, onClick, disabled }) => (
    <span
        className={b({ disabled }).mix(cls)}
        onClick={onClick}
    >
        <Icon
            cls={b('icon')}
            glyph="yes"
        >
            <LeftArrowIcon />
        </Icon>
    </span>
);

export default BackButton;
