import React from 'react';
import { block } from 'bem-cn';
import { Link } from 'lego-on-react';

import './DoublePaymentNotify.css';

const b = block('double-payment-notify');
const { searchParams } = new URL(window.location.href);
const hasQueryParam = searchParams.get('showDoublePaymentNotify') === '1';

export const DoublePaymentNotify = React.memo(({ cls }) => {
    if (!window.ya.connect.initial.showDoublePaymentNotify && !hasQueryParam) {
        return null;
    }

    return (
        <div className={b({}).mix(cls)}>
            <p>
                Если вы видите это сообщение, вас затронул сбой Яндекс.Коннекта.
            </p>
            <p>
                Из-за ошибки в работе наших систем счета за октябрь еще не сформированы. Они будут
                {' '}
                выставлены 2 декабря, в едином счете, включающем в себя расходы и за октябрь, и за ноябрь.
            </p>
            <p>
                Приносим извинения за доставленные неудобства. Наша
                {' '}
                <Link
                    theme="normal"
                    target="_blank"
                    cls={b('link').mix('external', 'link_external')}
                    url="https://yandex.ru/support/connect-tracker/troubleshooting.html"
                >
                    техническая поддержка
                </Link>
                {' '}
                будет на связи,
                {' '}
                чтобы помочь с расчетами и ответить на все возникшие у вас вопросы.
            </p>
        </div>
    );
});
