import React from 'react';
import ReactDOM from 'react-dom';

export default class extends React.PureComponent {
    constructor(props) {
        super(props);

        this._element = document.createElement('div');
        this._element.className = props.cls;
    }

    componentDidMount() {
        document.body.appendChild(this._element);
    }

    componentDidUpdate(prevProps) {
        let { cls } = this.props;

        if (cls !== prevProps.cls) {
            this._element.className = cls;
        }
    }

    componentWillUnmount() {
        document.body.removeChild(this._element);
    }

    render() {
        return ReactDOM.createPortal(this.props.children, this._element);
    }
}
