import isValidEmail from 'lib2/isValidEmail';
import { i18n } from 'i18n2';

const MaxLength = {
    LONG_NAME: 512,
    PHONE: 256,
    EMAIL: 256,
    POSTAL_CODE: 64,
    POSTAL_ADDRESS: 512,
    LEGAL_ADDRESS: 512,
    INN: 64,
    KPP: 64,
    BIK: 64,
    ACCOUNT: 20,
};

const legalPersonValidator = {

    long_name: {
        required: true,
        method: data => {
            const { long_name: longName } = data;

            if (!longName) {
                return i18n('subscription_validation.legal_person.long_name_undefined');
            }

            if (longName.length > MaxLength.LONG_NAME) {
                return i18n('subscription_validation.legal_person.long_name_too_long', {
                    maxLength: MaxLength.LONG_NAME,
                });
            }

            return null;
        },
    },

    phone: {
        required: true,
        method: data => {
            const { phone } = data;

            if (!phone) {
                return i18n('subscription_validation.common.phone_undefined');
            }

            if (phone.length > MaxLength.PHONE) {
                return i18n('subscription_validation.common.phone_too_long', {
                    maxLength: MaxLength.PHONE,
                });
            }

            return null;
        },
    },

    email: {
        required: true,
        method: data => {
            const { email } = data;

            if (!email) {
                return i18n('subscription_validation.common.email_undefined');
            }

            if (!isValidEmail(email)) {
                return i18n('subscription_validation.common.invalid_email');
            }

            if (email.length > MaxLength.EMAIL) {
                return i18n('subscription_validation.common.email_too_long', {
                    maxLength: MaxLength.EMAIL,
                });
            }

            return null;
        },
    },

    postal_code: {
        required: true,
        method: data => {
            const { postal_code: postalCode } = data;

            if (!postalCode) {
                return i18n('subscription_validation.legal_person.postal_code_undefined');
            }

            if (postalCode.length > MaxLength.POSTAL_CODE) {
                return i18n('subscription_validation.legal_person.postal_code_too_long', {
                    maxLength: MaxLength.POSTAL_CODE,
                });
            }

            return null;
        },
    },

    postal_address: {
        required: true,
        method: data => {
            const { postal_address: postalAddress } = data;

            if (!postalAddress) {
                return i18n('subscription_validation.legal_person.postal_address_undefined');
            }

            if (postalAddress.length > MaxLength.POSTAL_ADDRESS) {
                return i18n('subscription_validation.legal_person.postal_address_too_long', {
                    maxLength: MaxLength.POSTAL_ADDRESS,
                });
            }

            return null;
        },
    },

    legal_address: {
        required: true,
        method: data => {
            const { legal_address: legalAddress } = data;

            if (!legalAddress) {
                return i18n('subscription_validation.legal_person.legal_address_undefined');
            }

            if (legalAddress.length > MaxLength.LEGAL_ADDRESS) {
                return i18n('subscription_validation.legal_person.legal_address_too_long', {
                    maxLength: MaxLength.LEGAL_ADDRESS,
                });
            }

            return null;
        },
    },

    inn: {
        required: true,
        method: data => {
            const { inn } = data;

            if (!inn) {
                return i18n('subscription_validation.legal_person.inn_undefined');
            }

            if (inn.length > MaxLength.INN) {
                return i18n('subscription_validation.legal_person.inn_too_long', {
                    maxLength: MaxLength.INN,
                });
            }

            return null;
        },
    },

    kpp: {
        required: true,
        method: data => {
            const { kpp } = data;

            if (!kpp) {
                return i18n('subscription_validation.legal_person.kpp_undefined');
            }

            if (kpp && kpp.length > MaxLength.KPP) {
                return i18n('subscription_validation.legal_person.kpp_too_long', {
                    maxLength: MaxLength.KPP,
                });
            }

            return null;
        },
    },

    bik: {
        required: true,
        method: data => {
            const { bik } = data;

            if (!bik) {
                return i18n('subscription_validation.legal_person.bik_undefined');
            }

            if (bik.length > MaxLength.BIK) {
                return i18n('subscription_validation.legal_person.bik_too_long', {
                    maxLength: MaxLength.BIK,
                });
            }

            return null;
        },
    },

    account: {
        required: true,
        method: data => {
            const { account } = data;

            if (!account) {
                return i18n('subscription_validation.legal_person.account_undefined');
            }

            if (account.length > MaxLength.ACCOUNT) {
                return i18n('subscription_validation.legal_person.account_too_long', {
                    maxLength: MaxLength.ACCOUNT,
                });
            }

            return null;
        },
    },

};

export default legalPersonValidator;
