import isValidEmail from 'lib2/isValidEmail';
import { i18n } from 'i18n2';

const MaxLength = {
    FIRST_NAME: 170,
    MIDDLE_NAME: 170,
    LAST_NAME: 170,
    PHONE: 256,
    EMAIL: 256,
};

const naturalPersonValidator = {

    first_name: {
        required: true,
        method: data => {
            const { first_name: firstName } = data;

            if (!firstName) {
                return i18n('subscription_validation.natural_person.first_name_undefined');
            }

            if (firstName.length > MaxLength.FIRST_NAME) {
                return i18n('subscription_validation.natural_person.first_name_too_long', {
                    maxLength: MaxLength.FIRST_NAME,
                });
            }

            return null;
        },
    },

    middle_name: {
        required: true,
        method: data => {
            const { middle_name: middleName } = data;

            if (!middleName) {
                return i18n('subscription_validation.natural_person.middle_name_undefined');
            }

            if (middleName.length > MaxLength.MIDDLE_NAME) {
                return i18n('subscription_validation.natural_person.middle_name_too_long', {
                    maxLength: MaxLength.MIDDLE_NAME,
                });
            }

            return null;
        },
    },

    last_name: {
        required: true,
        method: data => {
            const { last_name: lastName } = data;

            if (!lastName) {
                return i18n('subscription_validation.natural_person.last_name_undefined');
            }

            if (lastName.length > MaxLength.LAST_NAME) {
                return i18n('subscription_validation.natural_person.last_name_too_long', {
                    maxLength: MaxLength.LAST_NAME,
                });
            }

            return null;
        },
    },

    phone: {
        required: true,
        method: data => {
            const { phone } = data;

            if (!phone) {
                return i18n('subscription_validation.common.phone_undefined');
            }

            if (phone.length > MaxLength.PHONE) {
                return i18n('subscription_validation.common.phone_too_long', {
                    maxLength: MaxLength.PHONE,
                });
            }

            return null;
        },
    },

    email: {
        required: true,
        method: data => {
            const { email } = data;

            if (!email) {
                return i18n('subscription_validation.common.email_undefined');
            }

            if (!isValidEmail(email)) {
                return i18n('subscription_validation.common.invalid_email');
            }

            if (email.length > MaxLength.EMAIL) {
                return i18n('subscription_validation.common.email_too_long', {
                    maxLength: MaxLength.EMAIL,
                });
            }

            return null;
        },
    },

};

export default naturalPersonValidator;
