import _get from 'lodash/get';
import getOrganization from 'lib2/getOrganization';
import directory from 'api2/directory';

export default function fetchResourceCount(serviceSlug) {
    if (serviceSlug === 'webmaster') {
        return Promise.resolve(_get(getOrganization(), 'domains.all', []).length);
    }

    return directory
        .send('GET', '/v11/resources/count/', {
            query: {
                service: serviceSlug,
            },
        })
        .then(({ ok, body: { count } }) => ok && count);
}
