import React from 'react';
import { block } from 'bem-cn';
import { formatCurrency } from 'i18n2';

import './index.css';

const b = block('discounted-price');

export default ({ currency, price, priceWithDiscount, cls }) => (
    <span className={b({}).mix(cls)}>
        {typeof priceWithDiscount === 'number' &&
        <span
            className={b('value', { discounted: true })}
            dangerouslySetInnerHTML={{ __html: formatCurrency(priceWithDiscount, currency) }}
        />}
        <span
            className={b('value')}
            dangerouslySetInnerHTML={{
                __html: typeof price === 'number' ? formatCurrency(price, currency) : '\u00a0',
            }}
        />
    </span>
);
