import React from 'react';
import { Button } from 'lego-on-react';
import { setCookie } from '@connect/cookies-lite';
import block from 'bem-cn';
import { i18n } from 'i18n2';
import './index.css';

const b = block('domain-restoration');

function transferDomain(domain, callback) {
    setCookie(`occupied_warning_${domain.name}`, 1);

    if (callback) {
        callback({
            ...domain,
            occupied: false,
        });
    }
}

const DomainRestoration = ({ cls, domain, onDomainTransfer }) => (
    <div className={b({}).mix(cls)}>
        <div
            className={b('option')}
            dangerouslySetInnerHTML={{ __html: i18n('domain.occupied_domain.option_1') }}
        />
        <div className={b('option-actions')}>
            <Button
                cls={b('button', { type: 'restore' })}
                theme="normal"
                size="m"
                url="/portal/restore"
                type="link"
            >
                {i18n('domain.occupied_warning.button.restore')}
            </Button>
        </div>
        <div
            className={b('option')}
            dangerouslySetInnerHTML={{ __html: i18n('domain.occupied_domain.option_2') }}
        />
        <div className={b('option-actions')}>
            <Button
                cls={b('button', { type: 'reassign-owner' })}
                theme="normal"
                size="m"
                onClick={() => transferDomain(domain, onDomainTransfer)}
            >
                {i18n('domain.warning.occupied_by_other_organization.reassign')}
            </Button>
        </div>
    </div>
);

export default DomainRestoration;
