import React from 'react';
import block from 'bem-cn';
import ServicePage from 'components2/ServicePage';
import ServiceHeader from 'components2/ServiceHeader';
import DomainList from 'components2/DomainList';
import ServiceViewLink from 'components2/ServiceViewLink';
import TabLink from 'components2/TabLink';
import { DomainStore } from 'lib2/stores';
import hasOwnedDomains from 'lib2/hasOwnedDomains';
import { i18n } from 'i18n2';
import './index.css';

const b = block('domain-service-page');

export default class DomainServicePage extends React.PureComponent {
    constructor(props) {
        super(props);

        this.state = {};

        this._onStoreChange = this._onStoreChange.bind(this);
    }

    componentDidMount() {
        this._storeListener = DomainStore.onChange(this._onStoreChange);
    }

    componentWillUnmount() {
        this._storeListener.remove();
    }

    _onStoreChange() {
        this.setState({
            withoutDomains: Object.keys(DomainStore.get('list')).length === 0,
            shouldShowMailWarning: !hasOwnedDomains(),
        });
    }

    render() {
        const { withoutDomains, shouldShowMailWarning } = this.state;
        const { cls } = this.props;

        const mailWarning = withoutDomains ?
            i18n('service_page.webmaster.no_domain_mail_warning') :
            i18n('service_page.webmaster.unverified_domain_mail_warning');

        return (
            <ServicePage
                cls={b.mix(cls)}
                serviceSlug="webmaster"
            >
                {shouldShowMailWarning && (
                    <div className={b('mail-warning')}>
                        {mailWarning}
                    </div>
                )}
                <ServiceHeader
                    cls={b('header')}
                    serviceSlug="webmaster"
                    actions={[
                        <ServiceViewLink
                            serviceSlug="webmaster"
                            key="view"
                        />,
                    ]}
                />
                <div className={b('tabs')}>
                    <TabLink.Group>
                        <TabLink url="/portal/services/webmaster">
                            {i18n('service_page.webmaster.resources')}
                        </TabLink>
                    </TabLink.Group>
                    <TabLink.Pane>
                        <DomainList cls={b('domain-list')} />
                    </TabLink.Pane>
                </div>
            </ServicePage>
        );
    }
}
