import React from 'react';
import block from 'bem-cn';
import { i18n } from 'i18n2';
import './index.css';

const b = block('domain-status');

const DomainStatus = ({ cls, domain, badge, type = 'page' }) => {
    let { gendarme: loaded, owned, mx, delegated, occupied, missing } = domain;
    let key = 'pending';
    let badgeStatus = 'pending';

    if (missing) {
        key = 'not_found';
    } else if (occupied) {
        key = 'occupied';
    } else if (loaded) {
        if (!owned) {
            key = 'unverified';
            badgeStatus = 'not-ready';
        } else if (!mx) {
            key = 'no_mx';
            badgeStatus = 'almost-ready';
        } else if (delegated) {
            key = 'delegated';
            badgeStatus = 'ready';
        } else {
            key = 'verified';
            badgeStatus = 'ready';
        }
    }

    return (
        <div className={b({ loaded, occupied }).mix(cls)}>
            {i18n(`domain_status.${type}.${key}`)}
            {badge && <span className={b('badge', { status: badgeStatus })} />}
        </div>
    );
};

export default DomainStatus;
