import React from 'react';
import block from 'bem-cn';
import getHelpUrl from 'lib2/getHelpUrl';
import { i18n } from 'i18n2';
import './index.css';

const b = block('domain-status-details');

const DomainStatusDetails = ({ cls, domain }) => {
    let { gendarme: loaded, owned, mx, delegated } = domain;
    let key;

    if (!loaded) {
        return null;
    }

    if (!owned) {
        key = 'not_confirmed';
    } else if (!mx) {
        key = 'no_mx';
    } else if (delegated) {
        key = 'delegated';
    } else {
        key = 'confirmed';
    }

    return (
        <div
            className={b({ owned, mx, delegated }).mix(cls)}
            dangerouslySetInnerHTML={{
                __html: i18n(`domain.status_details.${key}`, {
                    troubleshooting_url: getHelpUrl('ui.help.troubleshooting'),
                    mx_help_url: getHelpUrl('ui.help.mx'),
                }),
            }}
        />
    );
};

export default DomainStatusDetails;
