import React from 'react';
import { Icon } from 'lego-on-react';
import block from 'bem-cn';
import TooltipBox from 'components/TooltipBox';
import CrownIcon from 'components/Icon/Crown';
import { i18n } from 'i18n2';
import './index.css';

const b = block('domain-title');

const DomainTitle = ({ cls, domain, text }) => (
    <div className={b({}).mix(cls)}>
        <span className={b('name')}>
            {text || domain.name}
        </span>
        {domain.master && (
            <TooltipBox
                tip={i18n('domain.tip.master_domain')}
                theme="normal"
                to="right"
                size="s"
            >
                <Icon
                    cls={b('icon')}
                    glyph="yes"
                >
                    <CrownIcon />
                </Icon>
            </TooltipBox>
        )}
    </div>
);

export default DomainTitle;
