import React from 'react';
import { Footer, LangSwitcher, Link } from 'lego-on-react';
import { block } from 'bem-cn';
import RequestMetadata from 'components2/RequestMetadata';
import { ConfigStore, SessionStore } from 'lib2/stores';
import getHelpUrl from 'lib2/getHelpUrl';
import getPath from 'lib2/getPath';
import { i18n } from 'i18n2';

import './index.css';

const START_YEAR = 2001;
const CURRENT_YEAR = new Date().getFullYear();

const YaTldMap = {
    tr: 'com.tr',
};

const b = block('footer');

export default ({ showDownloads, cls }) => {
    const locale = ConfigStore.get('app.locale');
    const tld = ConfigStore.get('app.tld');
    const region = SessionStore.get('current.country');

    return (
        <Footer
            tld={tld}
            region={region}
            cls={cls}
        >
            <Footer.Column>
                <LangSwitcher
                    theme="normal"
                    size="s"
                    lang={locale}
                    name={locale.toUpperCase()}
                    retpath={window.location.href}
                    tld={tld}
                    secretKey={window.ya.connect.initial.sk}
                    nomore
                >
                    {ConfigStore.get('app.acceptedLocales').map(name => {
                        if (name !== locale) {
                            return (
                                <LangSwitcher.Lang
                                    lang={name}
                                    name={i18n(`common_vocab.lang_switch.${name}`) || name}
                                    key={name}
                                />
                            );
                        }
                    })}
                </LangSwitcher>
                <Footer.Link url={getHelpUrl('ui.help.main', { tld: YaTldMap[locale] || tld })}>
                    {i18n('footer.help')}
                </Footer.Link>
                <Footer.Link url="/?noredirect=1">
                    {i18n('footer.promo')}
                </Footer.Link>
                {showDownloads &&
                <Footer.Link url={getPath('downloads')}>
                    {i18n('footer.downloads')}
                </Footer.Link>}
            </Footer.Column>
            <Footer.Column side="right">
                <RequestMetadata cls={b('meta')} />
                <span className={b('copyright-dates')}>
                    {`© ${START_YEAR}–${CURRENT_YEAR}`}
                </span>
                {'\u00a0'}
                <Link
                    cls={b('copyright-link')}
                    url={ConfigStore.get('ui.relatedServices.yandex')}
                    theme="normal"
                >
                    {i18n('footer.yandex')}
                </Link>
            </Footer.Column>
        </Footer>
    );
};
