import React from 'react';
import * as packageMeta from '@yandex-lego/serp-header/static.meta.js';
import * as User from '@yandex-lego/serp-header/dist/organizations/user2.desktop';
import buildUrl from '@connect/url-placeholders';
import { getCookie } from '@connect/cookies-lite';
import { ConfigStore } from 'lib2/stores';
import getOrgChangeUrl from 'lib2/getOrgChangeUrl';
import getHelpUrl from 'lib2/getHelpUrl';
import getRetpath from 'lib2/getRetpath';
import getNonce from 'lib2/getNonce';
import { MenuOptions } from './options';
import './user2.css';

function getCustomMenuItems() {
    return ['about_me', 'offer', 'leave_org']
        .map(key => {
            let { url, text, available } = MenuOptions[key];

            if (typeof available === 'function' ? available() : available !== false) {
                return {
                    text,
                    url: typeof url === 'function' ? url() : url,
                    action: `custom_${key}`,
                };
            }
        })
        .filter(Boolean);
}

export default class User2 extends React.PureComponent {
    constructor(props) {
        super(props);

        this._nonce = getNonce();

        if (!document.querySelector('script.user2')) {
            document.head.appendChild(
                Object.assign(document.createElement('script'), {
                    src: `${packageMeta.BASE_PATH}organizations/user2/user2-base.desktop.client.js`,
                    className: 'user2',
                })
            );
        }
    }

    render() {
        let { cls, user = {} } = this.props;
        let { tld, locale, isProd } = ConfigStore.get('app');
        let retpath = getRetpath('/portal/home');

        return (
            <div
                className={cls}
                dangerouslySetInnerHTML={{
                    __html: User.getContent({
                        tld,
                        lang: locale,
                        nonce: this._nonce,
                        ctx: {
                            organizationsUrl: buildUrl(ConfigStore.get('org.list'), { tld }),
                            contextSwitchUrl: getOrgChangeUrl(null, retpath),
                            addOrganizationUrl: buildUrl(ConfigStore.get('org.add'), {
                                retpath,
                                source: 'connect',
                                preset: '',
                            }),
                            passportHost: buildUrl(ConfigStore.get('passport.host'), { tld }),
                            accountsUrl: buildUrl(ConfigStore.get('passport.accounts'), { tld }),
                            avatarHost: ConfigStore.get('ui.avatar.host'),
                            helpUrl: getHelpUrl('ui.help.main', { tld }),
                            customMenuItems: getCustomMenuItems(),
                            noCounter: !isProd,
                            hasPlus: isProd,
                            yaplusAvailable: isProd,
                            retpath,
                            uid: user.id,
                            avatarId: user.avatar_id,
                            yu: getCookie('yandexuid'),
                            name: user.display_name || user.nickname || user.login,
                            source: 'connect',
                            secretKey: window.ya.connect.initial.sk,
                        },
                    }),
                }}
            />
        );
    }
}
