import React from 'react';
import { Icon } from 'lego-on-react';
import block from 'bem-cn';
import BrightCircledPlusIcon from 'components/Icon/BrightCircledPlus';
import NavLink from 'components2/NavLink';
import hasPermission from 'lib2/hasPermission';
import hasOwnedDomains from 'lib2/hasOwnedDomains';
import isAdmin from 'lib2/isAdmin';
import isInternal from 'lib2/isInternal';
import isCompleteOrganization from 'lib2/isCompleteOrganization';
import getOrganization from 'lib2/getOrganization';
import metrika from 'api2/metrika';
import { i18n } from 'i18n2';
import './index.css';

const b = block('sidebar');

// eslint-disable-next-line complexity
const LegacySidebar = () => {
    let isIncompleteOrg = !isCompleteOrganization();

    if (!isIncompleteOrg && !isAdmin()) {
        return null;
    }

    let canViewDepts = isIncompleteOrg || hasPermission('edit_department') || hasPermission('add_departments');
    let canViewGroups = isIncompleteOrg || hasPermission('add_groups') || hasPermission('edit_department');
    let canViewServices = isIncompleteOrg || hasPermission('manage_services');

    let rootDepts = getOrganization().root_departments;

    return (
        <div className={b()}>
            {canViewDepts && rootDepts && rootDepts.map(({ id, name }) => (
                <MenuItem
                    text={name}
                    url={`/portal/admin/departments/${id}`}
                    iconId="depts"
                    trackId="Корневой отдел"
                    disabled={isIncompleteOrg}
                    main
                    hard
                    key={id}
                />
            ))}
            {canViewGroups && (
                <MenuItem
                    text={i18n('common.groups')}
                    url="/portal/admin/groups"
                    iconId="groups"
                    trackId="Команды"
                    disabled={isIncompleteOrg}
                    hard
                    main
                    action={(
                        <NavLink
                            theme="normal"
                            url="/portal/admin/groups#add-group"
                            title={i18n('group.action_description.add')}
                            hard
                        >
                            <Icon><BrightCircledPlusIcon /></Icon>
                        </NavLink>
                    )}
                />
            )}
            {canViewGroups && isInternal() && (
                <MenuItem
                    text={i18n('sections.groups.admin')}
                    url="/portal/admin/groups/admin"
                    trackId="Команды - Я администратор"
                    disabled={isIncompleteOrg}
                    hard
                />
            )}
            {canViewGroups && isInternal() && (
                <MenuItem
                    text={i18n('sections.groups.member')}
                    url="/portal/admin/groups/member"
                    trackId="Команды - Я участник"
                    disabled={isIncompleteOrg}
                    hard
                />
            )}
            {canViewServices && (
                <MenuItem
                    text={i18n('services.plans_and_services')}
                    url="/portal/home"
                    iconId="services"
                    trackId="Тарифы и сервисы"
                    disabled={isIncompleteOrg}
                    hard
                    main
                />
            )}
            {canViewServices && hasPermission('manage_tracker') && (
                <MenuItem
                    text={i18n('services.name.tracker')}
                    url="/portal/services/tracker"
                    trackId="Трекер"
                    disabled={isIncompleteOrg}
                    hard
                />
            )}
            {canViewServices && hasPermission('manage_mail') && (
                <MenuItem
                    text={i18n('services.name.mail')}
                    url="/portal/services/mail"
                    trackId="Почта"
                    disabled={isIncompleteOrg}
                    hard
                />
            )}
            {(isIncompleteOrg || hasPermission('can_pay')) && (
                <MenuItem
                    text={i18n('sections.balance')}
                    url="/portal/balance"
                    matches={[
                        '/portal/balance',
                        '/portal/balance/contract',
                    ]}
                    iconId="balance"
                    trackId="Баланс"
                    disabled={isIncompleteOrg}
                    main
                />
            )}
            {(isIncompleteOrg || hasPermission('edit_organization') || hasPermission('delete_organization')) && (
                <MenuItem
                    text={i18n('sections.organization_profile')}
                    url="/portal/profile"
                    iconId="profile"
                    trackId="Профиль организации"
                    disabled={isIncompleteOrg}
                    main
                    hard
                />
            )}
            {(isIncompleteOrg || hasPermission('change_role')) && (
                <MenuItem
                    text={i18n('sections.customization.admins')}
                    url="/portal/admin/customization/admins"
                    trackId="Администраторы"
                    disabled={isIncompleteOrg}
                    hard
                />
            )}
            {(isIncompleteOrg || hasPermission('edit_dns')) && (
                <MenuItem
                    text={i18n('sections.customization.dns')}
                    url="/portal/services/webmaster"
                    trackId="Управление DNS"
                    disabled={isIncompleteOrg}
                    hard
                />
            )}
            {(isIncompleteOrg || hasPermission('add_domains')) && (
                <MenuItem
                    text={i18n('sections.customization.domains')}
                    url="/portal/services/webmaster"
                    trackId="Домены"
                    hard
                    action={(
                        <NavLink
                            theme="normal"
                            url="/portal/services/webmaster#add-domain"
                            title={i18n('domain.action_description.add')}
                            hard
                        >
                            <Icon><BrightCircledPlusIcon /></Icon>
                        </NavLink>
                    )}
                />
            )}
            {(isIncompleteOrg || hasOwnedDomains()) && (
                <MenuItem
                    text={i18n('sections.customization.general')}
                    url="/portal/admin/customization/general"
                    trackId="Дополнительные настройки"
                    disabled={isIncompleteOrg}
                    hard
                />
            )}
        </div>
    );
};

const MenuItem = ({ iconId, text, trackId, disabled = false, main = false, action, ...linkProps }) => (
    <div className={b('menu-item', { main, disabled, 'with-action': Boolean(action) })}>
        <span className={b('menu-item-link-container')}>
            <NavLink
                cls={b('menu-item-link')}
                {...linkProps}
                theme="sidebar"
                onClick={trackId && (() => metrika.send('Сайдбар', trackId, window.location.pathname))}
            >
                <span className={b('menu-item-icon', { type: iconId })} />
                <span className={b('menu-item-text')}>
                    {text}
                </span>
            </NavLink>
        </span>
        {action && (
            <span className={b('menu-item-action')}>
                {action}
            </span>
        )}
    </div>
);

export default LegacySidebar;
