import buildUrl from '@connect/url-placeholders';
import isAdmin from 'lib2/isAdmin';
import { SessionStore, ConfigStore } from 'lib2/stores';

const MailServiceRedirect = () => {
    const url = buildUrl(
        isAdmin() ?
            ConfigStore.get('mail.admin') :
            ConfigStore.get('mail.mail'),
        SessionStore.get('context')
    );

    window.location.href = url;

    return null;
};

export default MailServiceRedirect;
