import React from 'react';
import { block } from 'bem-cn';

import { i18n, formatDate } from 'i18n2';
import { ConfigStore } from 'lib2/stores';

import './index.css';

const b = block('metrika-notify');

export const MetrikaNotify = React.memo(({ cls }) => {
    return (
        <div className={b({}).mix(cls)}>
            <p
                dangerouslySetInnerHTML={{
                    __html: i18n('metrika-notify.text1', {
                        date: formatDate('2021-07-15'), // 15 июля 2021
                        url: ConfigStore.get('ui.help.reorg'),
                    }),
                }}
            />
            <p
                dangerouslySetInnerHTML={{
                    __html: i18n('metrika-notify.text2', {
                        url1: ConfigStore.get('ui.help.metricsTagAccess'),
                        url2: ConfigStore.get('ui.help.metricsDetachTag'),
                    }),
                }}
            />
            <p
                dangerouslySetInnerHTML={{
                    __html: i18n('metrika-notify.text3', {
                        url: ConfigStore.get('ui.help.metrikaGeneralAccess'),
                    }),
                }}
            />
        </div>
    );
});

export default MetrikaNotify;
