// lego Modal без изменений + стандартные составляющие модального окна
import React from 'react';
import { Modal, Icon, Spin, Button } from 'lego-on-react';
import block from 'bem-cn';
import RequestMetadata from 'components2/RequestMetadata';
import { i18n } from 'i18n2';

import './index.css';

const b = block('modal');

export default Modal;

Modal.Title = ({ children }) =>
    <div className={b('title')}>{children}</div>;

// чтобы Modal.CloseButton спозиционировался стилями напротив заголовка,
// нужно поставить его сразу после Modal.Title
Modal.CloseButton = ({ onClick }) => (
    <div
        className={b('close-button', { clickable: Boolean(onClick) })}
        onClick={onClick}
    >
        <Icon type="cross" />
    </div>
);

Modal.Body = ({ children, type }) => (
    <React.Fragment>
        <div className={b('body', { type })}>
            {children}
        </div>
        <RequestMetadata cls={b('meta')} />
    </React.Fragment>
);

// Modal.Actions - контейнер для Modal.LeftActions и Modal.RightActions,
// если нужны и те, и другие
Modal.Actions = ({ children, type }) =>
    <div className={b('actions', { container: true, type })}>{children}</div>;

Modal.LeftActions = ({ children, type }) =>
    <div className={b('actions', { side: 'left', type })}>{children}</div>;

Modal.RightActions = ({ children, type }) =>
    <div className={b('actions', { side: 'right', type })}>{children}</div>;

Modal.AlertActions = ({
    onConfirm,
    confirmCaption,
    confirmDisabled,
}) => (
    <Modal.RightActions type="alert">
        <Button
            theme="action"
            view="default"
            tone="default"
            size="m"
            cls={b('button', { type: 'confirm' })}
            disabled={confirmDisabled}
            onClick={() => onConfirm && onConfirm()}
        >
            {confirmCaption || i18n('common.action.ok')}
        </Button>
    </Modal.RightActions>
);

Modal.ConfirmActions = ({
    onConfirm,
    onCancel,
    confirmCaption,
    cancelCaption,
    confirmDisabled,
}) => (
    <Modal.RightActions type="confirm">
        <Button
            theme="pseudo"
            view="default"
            tone="default"
            size="m"
            cls={b('button', { type: 'cancel' })}
            onClick={() => onCancel && onCancel()}
        >
            {cancelCaption || i18n('common.action.cancel')}
        </Button>
        <Button
            theme="action"
            view="default"
            tone="default"
            size="m"
            cls={b('button', { type: 'confirm' })}
            disabled={confirmDisabled}
            onClick={() => onConfirm && onConfirm()}
        >
            {confirmCaption || i18n('common.action.ok')}
        </Button>
    </Modal.RightActions>
);

Modal.Busy = ({ visible }) => visible ? (
    <div className={b('busy')}>
        <Spin
            cls={b('busy-spin')}
            position="center"
            size="s"
            progress
        />
    </div>
) : null;
