import getOrganization from 'lib2/getOrganization';
import { OrgStore } from 'lib2/stores';
import directory from 'api2/directory';

export default function updateOrgField(key, value) {
    return directory
        .send('PATCH', '/v11/organization/', {
            body: JSON.stringify({
                [key]: value,
            }),
        })
        .then(({ ok }) => ok && OrgStore.set([getOrganization().id, key], value));
}
