import React from 'react';
import { Menu } from 'lego-on-react';
import { OrgStore } from 'lib2/stores';
import getRetpath from 'lib2/getRetpath';
import getOrgChangeUrl from 'lib2/getOrgChangeUrl';
import metrika from 'api2/metrika';
import bOrgSwitch from './block';

function selectOrg(event, orgId) {
    metrika.send(
        'Переключатель организаций',
        'Выбор организации',
        window.location.pathname
    );

    window.location.href = getOrgChangeUrl(orgId, getRetpath('/portal/home'));
}

export default ({ selectedId }) => (
    <Menu
        theme="normal"
        size="m"
        type="radio"
        width="max"
        cls={bOrgSwitch('list')}
        val={selectedId}
        onClick={selectOrg}
    >
        {Object.values(OrgStore.getState())
            .map(({ id, name }) => (
                <Menu.Item val={id} key={id}>
                    {name}
                </Menu.Item>
            ))}
    </Menu>
);
