import React from 'react';
import { Dropdown, Menu, Icon } from 'lego-on-react';
import { OrgStore } from 'lib2/stores';
import getOrganization from 'lib2/getOrganization';
import isExternalAdmin from 'lib2/isExternalAdmin';
import { Plus as PlusIcon } from 'components/Icon';
import { i18n } from 'i18n2';
import metrika from 'api2/metrika';
import AddOrgModal from './AddOrgModal';
import OrgList from './OrgList';
import bOrgSwitch from './block';

import './index.css';

export default class extends React.Component {
    constructor(props) {
        super(props);

        this.state = {};

        this._init = this._init.bind(this);
        this._update = this._update.bind(this);
        this._onAdd = this._onAdd.bind(this);
        this._closeModal = this._closeModal.bind(this);
    }

    _update() {
        let { id, name } = getOrganization();

        this.setState({
            available: isExternalAdmin() || Object.keys(OrgStore.getState()).length > 1,
            id,
            name,
        });
    }

    componentDidMount() {
        this._update();
        this._orgStoreListener = OrgStore.onChange(this._update);
    }

    componentDidUpdate(prevProps, prevState) {
        if (this.state.available && !prevState.available) {
            metrika.send(
                'Переключатель организаций',
                'Количество организаций',
                Object.keys(OrgStore.getState()).length,
                window.location.pathname
            );
        }
    }

    componentWillUnmount() {
        this._orgStoreListener.remove();
    }

    _init(menu) {
        if (menu) {
            this._menu = menu;
        }
    }

    _onAdd() {
        if (this._menu) {
            this._menu._onOutsideClick(); // закроет меню
        }

        this.setState({
            modalOpen: true,
        });

        metrika.send(
            'Переключатель организаций',
            'Добавить организацию',
            window.location.pathname
        );
    }

    _closeModal() {
        this.setState({
            modalOpen: false,
        });
    }

    render() {
        let { available, id, name, modalOpen } = this.state;

        if (!available) {
            return null;
        }

        return (
            <Dropdown
                size="m"
                switcher="button2"
                theme="normal"
                width="max"
                cls={bOrgSwitch({}).mix(this.props.cls)}
                hasTick
                ref={this._init}
            >
                <Dropdown.Switcher>
                    <div className={bOrgSwitch('text')}>
                        {name}
                    </div>
                </Dropdown.Switcher>
                <Dropdown.Popup>
                    <div className={bOrgSwitch('popup')}>
                        <OrgList selectedId={id} />
                        <Menu
                            cls={bOrgSwitch('options')}
                            theme="normal"
                            size="m"
                        >
                            <Menu.Item onClick={this._onAdd}>
                                <Icon><PlusIcon /></Icon>
                                {i18n('common.new_organization')}
                            </Menu.Item>
                        </Menu>
                        <AddOrgModal
                            visible={modalOpen}
                            onCancel={this._closeModal}
                        />
                    </div>
                </Dropdown.Popup>
            </Dropdown>
        );
    }
}
