import React from 'react';
import { block } from 'bem-cn';
import { i18n } from 'i18n2';

import Modal from 'components2/Modal';
import TrustPaymentForm from 'components2/TrustPaymentForm';

import './index.css';

const b = block('payment-modal');

export default class PaymentModal extends React.PureComponent {
    render() {
        const { cls, onCancel, paymentUrl, onSuccess, onFailure } = this.props;
        const visible = Boolean(paymentUrl);

        return (
            <Modal
                cls={b({ pointer: 'none' }).mix(cls)}
                visible={visible}
            >
                <Modal.Title>
                    {i18n('subscription.balance.payment.title')}
                </Modal.Title>
                <Modal.CloseButton onClick={onCancel} />
                <Modal.Body>
                    <div className={b('iframe')}>
                        {visible && (
                            <TrustPaymentForm
                                paymentUrl={paymentUrl}
                                onSuccess={onSuccess}
                                onFailure={onFailure}
                            />
                        )}
                    </div>
                    {!visible && <div className={b('overlay')} />}
                </Modal.Body>
            </Modal>
        );
    }
}
