import React from 'react';
import block from 'bem-cn';
import './index.css';

const b = block('placeholder');

const Placeholder = ({ title, description, action, cls, icon }) => (
    <div className={b({}).mix(cls)}>
        <div className={b('content')}>
            {icon && <div className={b('icon', { type: icon })} />}
            {title && (
                <h3 className={b('title')}>
                    {title}
                </h3>
            )}
            {description && (
                <div className={b('description')}>
                    {description}
                </div>
            )}
            {action && (
                <div className={b('action')}>
                    {action}
                </div>
            )}
        </div>
    </div>
);

export default Placeholder;
