import React from 'react';
import { Icon } from 'lego-on-react';
import { block } from 'bem-cn';
import TooltipBox from 'components/TooltipBox';
import QuestionIcon from 'components/Icon/Question';
import WaveOverlay from 'components2/WaveOverlay';

import './index.css';

const b = block('pricing-details');

const PricingDetails = ({ children, cls, busy, progress, title }) => (
    <div className={b({ busy }).mix(cls)}>
        {title &&
        <div className={b('title')}>
            {title}
        </div>}
        <div className={b('body')}>
            {children}
        </div>
        <WaveOverlay
            progress={progress}
            transparent
        />
    </div>
);

PricingDetails.Slot = ({ children, tip, htmlTip, description, label }) => (
    <div className={b('slot')}>
        {label && (
            <div className={b('slot-label')}>
                {label}
            </div>
        )}
        <div className={b('slot-value')}>
            {children}
            {(tip || htmlTip) &&
            <TooltipBox
                tip={tip}
                htmlTip={htmlTip}
                theme="normal"
                to="right"
                size="s"
            >
                <Icon glyph="yes"><QuestionIcon /></Icon>
            </TooltipBox>}
        </div>
        {description && (
            <div className={b('slot-description')}>
                {description}
            </div>
        )}
    </div>
);

export default PricingDetails;
