import React from 'react';
import { Button } from 'lego-on-react';
import block from 'bem-cn';
import { i18n } from 'i18n2';

import metrika from 'api2/metrika';
import RemoveOrgModal from 'components2/RemoveOrgModal';
import hasPermission from 'lib2/hasPermission';

const b = block('remove-org-control');

export default class RemoveOrgControl extends React.Component {
    constructor(props) {
        super(props);

        this.state = {};

        this._confirm = this._confirm.bind(this);
        this._cancel = this._cancel.bind(this);
    }

    componentWillUnmount() {
        this._unmounted = true;
    }

    _confirm() {
        this.setState({
            confirmOpen: true,
        });

        metrika.send(
            'Профиль организации',
            'Удаление организации',
            'Уверены?',
        );
    }

    _cancel() {
        this.setState({
            confirmOpen: false,
        });

        metrika.send(
            'Профиль организации',
            'Удаление организации',
            'Отмена',
        );
    }

    render() {
        let { cls, ...buttonProps } = this.props;
        let { confirmOpen } = this.state;

        if (!hasPermission('edit_organization')) {
            return null;
        }

        return (
            <React.Fragment>
                <Button
                    cls={b({}).mix(cls)}
                    theme="action"
                    view="default"
                    tone="red"
                    size="m"
                    text={i18n('organization_profile.edit_menu.remove')}
                    {...buttonProps}
                    onClick={this._confirm}
                />
                <RemoveOrgModal
                    visible={confirmOpen}
                    onCancel={this._cancel}
                />
            </React.Fragment>
        );
    }
}
