import React from 'react';
import { Button } from 'lego-on-react';
import block from 'bem-cn';
import Modal from 'components2/Modal';
import getOrganization from 'lib2/getOrganization';
import fetchOrgLogo from 'lib2/fetchOrgLogo';
import notify from 'lib2/notify';
import directory from 'api2/directory';
import metrika from 'api2/metrika';
import { i18n } from 'i18n2';

const b = block('remove-org-logo-control');

export default class RemoveOrgLogoControl extends React.Component {
    constructor(props) {
        super(props);

        this.state = {};

        this._confirm = this._confirm.bind(this);
        this._cancel = this._cancel.bind(this);
        this._remove = this._remove.bind(this);
    }

    componentWillUnmount() {
        this._unmounted = true;
    }

    _confirm() {
        metrika.send(
            'Профиль организации',
            'Удаление логотипа',
            'Уверены?',
        );

        this.setState({
            confirmOpen: true,
        });
    }

    _cancel() {
        metrika.send(
            'Профиль организации',
            'Удаление логотипа',
            'Отмена',
        );

        this.setState({
            confirmOpen: false,
        });
    }

    _remove() {
        metrika.send(
            'Профиль организации',
            'Удаление логотипа',
            'Удалить',
        );

        this.setState({
            busy: true,
        });

        directory
            .send('DELETE', `/v11/organizations/${getOrganization().id}/change-logo/`)
            .then(({ ok }) => {
                metrika.send(
                    'Профиль организации',
                    'Удаление логотипа',
                    ok ? 'Удалён' : 'Ошибка',
                );

                if (!ok) {
                    notify(i18n('common.status.failed'), 'error');

                    return;
                }

                notify(i18n('common.status.done'), 'success');

                return fetchOrgLogo();
            })
            .finally(() => {
                if (!this._unmounted) {
                    this.setState({
                        busy: false,
                        confirmOpen: false,
                    });
                }
            });
    }

    render() {
        let { cls, ...buttonProps } = this.props;
        let { confirmOpen, busy } = this.state;

        return (
            <React.Fragment>
                <Button
                    cls={b({}).mix(cls)}
                    theme="link"
                    size="m"
                    text={i18n('logo.remove_logo')}
                    {...buttonProps}
                    onClick={this._confirm}
                />
                <Modal
                    cls={b('confirm-modal')}
                    visible={confirmOpen}
                >
                    <Modal.Title>
                        {i18n('logo.confirm_logo_removal.title')}
                    </Modal.Title>
                    <Modal.CloseButton onClick={this._cancel} />
                    <Modal.Body>
                        {i18n('logo.confirm_logo_removal.message')}
                    </Modal.Body>
                    <Modal.ConfirmActions
                        onConfirm={this._remove}
                        onCancel={this._cancel}
                        confirmCaption={i18n('logo.confirm_logo_removal.confirm')}
                    />
                    <Modal.Busy visible={busy} />
                </Modal>
            </React.Fragment>
        );
    }
}
