import React from 'react';
import block from 'bem-cn';

import { Icon, Spin } from 'lego-on-react';
import { i18n } from 'i18n2';
import LeftArrowIcon from 'components/Icon/LeftArrow';
import NavLink from 'components2/NavLink';
import './index.css';

const b = block('resource-header');

function getText(serviceSlug, key, params) {
    return i18n(`resource_page.${serviceSlug}.${key}`, params) ||
        i18n(`resource_page.default.${key}`, params);
}

const ResourceHeader = ({
    serviceSlug,
    resource: { id, name, description },
    actions,
    busy,
    cls,
    children,
}) => {
    if (busy) {
        return (
            <div className={b.mix(cls)}>
                <Spin
                    progress
                    size="m"
                    position="center"
                />
            </div>
        );
    }

    return (
        <div className={b.mix(cls)}>
            <div className={b('controls')}>
                <NavLink
                    cls={b('back')}
                    theme="black"
                    url={`/portal/services/${serviceSlug}`}
                    iconLeft={(
                        <Icon
                            cls={b('back-icon')}
                            glyph="yes"
                        >
                            <LeftArrowIcon />
                        </Icon>
                    )}
                    text={getText(serviceSlug, 'back')}
                />
                <div className={b('actions')}>
                    {actions}
                </div>
            </div>
            <div className={b('title')}>
                {name || getText(serviceSlug, 'default_name', { id })}
            </div>
            <div className={b('description')}>
                <span className={b('description-item')}>
                    {description}
                </span>
                <span className={b('description-item')}>
                    {id}
                </span>
            </div>
            {children}
        </div>
    );
};

export default ResourceHeader;
