import React from 'react';
import block from 'bem-cn';
import { i18n } from 'i18n2';
import ServicePage from 'components2/ServicePage';
import ServiceHeader from 'components2/ServiceHeader';
import ServiceResources from 'components2/ServiceResources';
import ServiceViewLink from 'components2/ServiceViewLink';
import ServiceDetails from 'components/ServiceDetails';
import ServiceResponsible from 'components2/ServiceResponsible';
import { MetrikaNotify } from 'components2/MetrikaNotify';
import TabLink from 'components2/TabLink';
import './index.css';

const b = block('resource-service-page');

const ResourceServicePage = ({ serviceSlug, cls }) => (
    <ServicePage
        cls={b({ slug: serviceSlug }).mix(cls)}
        serviceSlug={serviceSlug}
    >
        <ServiceHeader
            cls={b('header')}
            serviceSlug={serviceSlug}
            actions={[
                <ServiceViewLink
                    serviceSlug={serviceSlug}
                    key="view"
                />,
            ]}
        />
        <ServiceDetails>
            <ServiceResponsible serviceSlug={serviceSlug} />
            {serviceSlug === 'metrika' && <MetrikaNotify />}
        </ServiceDetails>
        <div className={b('tabs')}>
            <TabLink.Group>
                <TabLink url={`/portal/services/${serviceSlug}`}>
                    {i18n(`service_page.${serviceSlug}.resources`) || i18n('service_page.default.resources')}
                </TabLink>
            </TabLink.Group>
            <TabLink.Pane>
                <ServiceResources serviceSlug={serviceSlug} />
            </TabLink.Pane>
        </div>
    </ServicePage>
);

export default ResourceServicePage;
