import React from 'react';
import { block } from 'bem-cn';
import { Icon } from 'lego-on-react';
import CrossIcon from 'components/Icon/Cross';
import AvatarUnit from 'components2/AvatarUnit';

import './index.css';

const b = block('search-item');

export default class SearchItem extends React.PureComponent {
    constructor(props) {
        super(props);

        this._onRemove = this._onRemove.bind(this);
    }

    _onRemove() {
        const { object, type } = this.props;

        this.props.onRemove({ object, type });
    }

    render() {
        const { object, type = 'user', cls } = this.props;

        return (
            <div className={b({ type }).mix(cls)}>
                <AvatarUnit
                    cls={b('content')}
                    type={type}
                    object={object}
                />
                <div
                    className={b('button', { type: 'delete' })}
                    onClick={this._onRemove}
                >
                    <Icon
                        cls={b('button-icon')}
                    >
                        <CrossIcon />
                    </Icon>
                </div>
            </div>
        );
    }
}
