import React from 'react';
import { Icon } from 'lego-on-react';
import { block } from 'bem-cn';
import CircledCheckIcon from 'components/Icon/CircledCheck';
import CrossIcon from 'components/Icon/Cross';
import BodyPortal from 'components2/BodyPortal';

import './index.css';

const b = block('selection-bar');

const SelectionBar = ({ children, visible }) => (
    <BodyPortal cls={b({ visible })}>
        <Icon
            glyph="yes"
            cls={b('check-icon')}
        >
            <CircledCheckIcon />
        </Icon>
        {children}
    </BodyPortal>
);

SelectionBar.Status = ({ children }) =>
    <div className={b('status')}>{children}</div>;

SelectionBar.Actions = ({ children }) =>
    <div className={b('actions')}>{children}</div>;

SelectionBar.CloseButton = ({ onClick }) => (
    <div
        className={b('close-button', { clickable: Boolean(onClick) })}
        onClick={onClick}
    >
        <Icon glyph="yes">
            <CrossIcon />
        </Icon>
    </div>
);

export default SelectionBar;
