import React from 'react';
import { Icon, Link } from 'lego-on-react';
import getServiceMainAction from 'lib2/getServiceMainAction';
import isExternalAdmin from 'lib2/isExternalAdmin';
import ThinPlusIcon from 'components/Icon/ThinPlus';
import { i18n } from 'i18n2';

export default ({ serviceSlug, icon }) =>
    isExternalAdmin() ?
        null :
        <Link
            theme="normal"
            url={getServiceMainAction(serviceSlug).url}
            text={i18n(`dashboard.card.${serviceSlug}.action`) || i18n('dashboard.card.default.action')}
            iconLeft={icon || <Icon glyph="yes"><ThinPlusIcon /></Icon>}
        />;
