import React from 'react';
import { block } from 'bem-cn';
import TooltipBox from 'components/TooltipBox';

import './Badge.css';

const b = block('badge');

const Badge = ({ children, color = 'gray', size = 's', tip, htmlTip, cls }) => (
    <div className={b({ color, size }).mix(cls)}>
        <TooltipBox
            tip={tip}
            htmlTip={htmlTip}
            theme="normal"
            to="bottom"
            size={size}
        >
            <span className={b('text')}>
                {children}
            </span>
        </TooltipBox>
    </div>
);

export default Badge;
